﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Threading;
using System.Windows.Forms;

namespace KeyConfig
{
	public partial class frmPad : Form
	{
		public frmPad()
		{
			InitializeComponent();
			Application.ThreadException += new ThreadExceptionEventHandler(Application_ThreadException);
		}

		void Application_ThreadException(object sender, ThreadExceptionEventArgs e)
		{
			MessageBox.Show(e.Exception.ToString());
			this.Close();
		}

		internal void InitializeEditor(JoyPad pad)
		{
			try
			{
				chkDirectX.Checked = pad.DirectXFound;
				chkDirectInput.Checked = pad.DirectInputFound;
				chkPad.Checked = pad.DeviceFound;
				chkAccess.Checked = pad.DeviceAcquired;

				if (!pad.DeviceFound)
				{
					this.Text = "パッドが見つかりません";
				}
				else if (!pad.DeviceAcquired)
				{
					this.Text = "パッドの入力が取得できません";
				}
			}
			catch (Exception ex)
			{
				MessageBox.Show(ex.ToString());
			}
		}

		private void btnClose_Click(object sender, EventArgs e)
		{
			this.Close();
		}
	}
}
